DROP PROCEDURE [hips].[HealthProviderIndividualDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 02 April 2012
-- Description:   Deletes an existing record into the HealthProviderIndividuals Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderIndividualDelete] 
(
	  @HealthProviderIndividualID INT
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int,
			@intRowsAffected int

    SELECT  @intErrorCode = 0,
			@intRowsAffected = 0

    DELETE
     FROM [hips].[HealthProviderIndividual]
     WHERE [HealthProviderIndividualID] = @HealthProviderIndividualID

    SELECT @intErrorCode = @@ERROR,
   		   @intRowsAffected = @@ROWCOUNT

	SELECT @intRowsAffected AS RowsAffected

    RETURN(@intErrorCode)
END
GO

